#!/usr/bin/env python
# Set Plan Bar Color By Float.py
# Copyright 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070220 - Brian - first draft based on Set Plan Bar Color by Dependency

#import wx
#import re

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

if debug: print 'Start Script'


def SetPlanBarColor(self):

    # set local pointers to tables
    rid = self.ReportID  # current report
    drep = Data.Database['Report']
    drow = Data.Database['ReportRow']
    drt = Data.Database['ReportType']
    dt = Data.Database['Task']
    rr = drep[rid]

    # make sure report has report type
    if not rr.has_key('ReportTypeID') or not drt.has_key(rr['ReportTypeID']): 
        if debug: print "ReportType key not found"
        hint("Error: Can't find type of this report.")
        return
    rtid = rr['ReportTypeID']

    # is this a task report
    rt = drt[rtid] # pointer to report type record
    ta = rt.get('TableA')
    tb = rt.get('TableB')  # if two table report all inserts go at the end (less confusing to user)
    if not (ta == 'Task' or tb == 'Task'):
        hint('Use script only with Task reports.')
        return

    # change either the selection, if there is one, or all visible rows
    rows = [ self.Report.table.rows[x] for x in self.Report.GetSelectedRows() ]  # current selection -> row ids
    if not rows:
        # update all visible rows
        rows = self.Report.table.rows  # all visible rows in display order

    # get row ids for all task rows
    rids = [ x for x in rows if drow[x].get('TableName') == 'Task' ]

    interval = 0
    clist = Data.GetColumnList(self.ReportID)  # complete list of row id's in display order
    for c in clist:
        ctid = Data.ReportColumn[c]['ColumnTypeID']
        ct = Data.ColumnType[ctid]
        if ct.get('AccessType') != 's':  # not a time scale
            continue
        # period = ct.get('PeriodSize') or ct.get('Name')
        period, type = ct.get('Name').split('/')
        if type != 'Gantt': continue
        if period == 'Day':
            interval = 8
        elif period == 'Week':
            interval = 8 * 5
        elif period == 'Month':
            interval = 8 * 22
        elif period == 'Quarter':
            interval = 8 * 22 * 3
        elif period == 'Year':
            interval = 8 * 22 * 12
        if interval: break

    red = 'FF0000'
    orange = 'FF7500'
    yellow ='FFFF00'
    green = '00FF00'
    blue = '0000FF'
    indigo = '4B0082'
    violet = '8B00FF'

    # set color for each row
    for rowid in rids:
        taskid = drow[rowid].get('TableID')
        tfh = dt[taskid].get('TotalFloatHours')
        if not tfh:
            newcolor = red
        elif tfh < interval:
            newcolor = orange
        elif tfh < interval * 2:
            newcolor = yellow
        elif tfh < interval * 3:
            newcolor = green
        elif tfh < interval * 4:
            newcolor = blue
        elif tfh < interval * 5:
            newcolor = indigo
        else:
            newcolor = violet
        if drow[rowid].get('PlanBarColor') != newcolor:
            change = { 'Table': 'ReportRow', 'ID': rowid, 'PlanBarColor': newcolor }
            Data.Update(change)

    Data.SetUndo('Set Plan Bar Color By Float')

SetPlanBarColor(self)

if debug: print 'End Script'

